<?php

include_once "../admin/core/init.inc.php";

/*
 * Adspiritmedia Postback
 * Version 1.0
 * Author: Adspiritmedia 
 * Example : https://earn4me.online/postbacks/adspiritmedia.php?user_id={user_id}&payout={payout}&user_ip={user_ip}&offerName={offerName}&reward={reward}&country={country}&status={status}&debug={debug}
 */

// Get parameters from the URL
$user_id = $_GET['user_id'] ?? '';
$payout = $_GET['payout'] ?? '';
$user_ip = $_GET['user_ip'] ?? '';
$offerName = $_GET['offerName'] ?? '';
$amount = $_GET['reward'] ?? 0;
$country = $_GET['country'] ?? '';
$status = $_GET['status'] ?? '';

// Current timestamp
$timeCurrent = time();

$type = "Adspiritmedia: Offername: $offerName . IP: $user_ip";

// Handle Chargebacks
if ($status == 2) {
    $amount = -$amount;
    $payout = -$payout;
    $type .= " - Chargeback";
}

// Initialize necessary classes and objects
$configs = new functions($dbo);

$account = new account($dbo, 1);
$userdata = $account->getUserData($user_id);

// Check if the user exists
if ($userdata['username'] !== $user_id) {
    api::printError(ERROR_UNKNOWN, "Account Mismatch");
    // Send error code
    echo 0;
    die();
} else {
    // User exists, update user's points
    $newBalance = $userdata['points'] + $amount;

    // Update user's points
    $sql = "UPDATE users SET points = :newBalance WHERE login = :user_id";
    $stmt = $dbo->prepare($sql);
    $stmt->bindParam(':newBalance', $newBalance, PDO::PARAM_INT);
    $stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
    $stmt->execute();

    // Update user's tracker
    $sql = "INSERT INTO tracker(username, points, type, date) VALUES (:user_id, :amount, :type, :timeCurrent)";
    $stmt = $dbo->prepare($sql);
    $stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
    $stmt->bindParam(':amount', $amount, PDO::PARAM_INT);
    $stmt->bindParam(':type', $type, PDO::PARAM_STR);
    $stmt->bindParam(':timeCurrent', $timeCurrent, PDO::PARAM_INT);
    $stmt->execute();

    // Send success code
    echo 1;
    die();
}
